#ifndef _DRV_SIM_H_
#define _DRV_SIM_H_

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用變量 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// 只能SPI/IICT二選一
// #define SIM_MODE_SPI
 #define SIM_MODE_IIC
#define SIM_VECTOR 0x2c  

#define TXBUF_LENGTH    20
#define RXBUF_LENGTH    20
typedef struct
{
    unsigned char RxBuf[RXBUF_LENGTH];
    unsigned char TxBuf[TXBUF_LENGTH];
    unsigned char RxOffset;
    unsigned char TxOffset;
    unsigned char RxLength;
    unsigned char TxLength;
    unsigned char RxTimeOut;
	union {
		struct
		{
			unsigned char TxIsBusy : 1;
			unsigned char RxIsOK : 1;
		} b;
		unsigned char byte;
	} flag;
} SIM_STRUCT;

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用函數 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
void Drv_SIM_PowerOn();
void Drv_SIM_PowerDown();

unsigned char Drv_SIMSPI_TxRxByte(unsigned char txData);
void Drv_UartStartTx(unsigned char TxLength);
extern volatile SIM_STRUCT SIM_Data;

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 預定義 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                IIC  基本設置                                        @
//                            只能SPI/IIC/UART三選一                                   @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define SIM_IIC_ADDRESS 0xA0      //!< I2C slave address
#define SIM_IIC_DEBOUNCE_TIME 0    //!< 0-No debounce   1- 2 system clock debounce     2/3-4 system clock debounce
#define SIM_IIC_ADDRESS_WAKE_UP 1 //!< I2C Address Match Wake-up control
#define SIM_IIC_TIMEOUT 1         //!< 0-Disable 1-Enable I2C Time-out control
#define SIM_IIC_TIMEOUT_PERIOD 64 //!< IIC time-out time is equal to (SIM_IIC_TIMEOUT_PERIOD+1)×(32/fSUB)
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                SPI  基本設置                                         @
//                            只能SPI/IIC/UART三選一                                    @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//!< IO Pin share 設置
#define SET_SIM_SPI_PIN()   {SET_PA5_SCK_SCL(); SET_PA4_SDI_SDA(); SET_PA3_SDO(); SET_PA1_SCS();}  

#endif